/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;

public abstract class PathInterpolator
extends TransformInterpolator {
    private float[] knots;
    protected float currentInterpolationValue;
    protected int currentKnotIndex;

    PathInterpolator() {
    }

    public PathInterpolator(Alpha alpha, float[] fArray) {
        this(alpha, null, fArray);
    }

    public PathInterpolator(Alpha alpha, TransformGroup transformGroup, float[] fArray) {
        super(alpha, transformGroup);
        this.setKnots(fArray);
    }

    public PathInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float[] fArray) {
        super(alpha, transformGroup, transform3D);
        this.setKnots(fArray);
    }

    public int getArrayLengths() {
        return this.knots.length;
    }

    public void setKnot(int n2, float f2) {
        this.knots[n2] = f2;
    }

    public float getKnot(int n2) {
        return this.knots[n2];
    }

    protected void setKnots(float[] fArray) {
        if ((double)fArray[0] < -1.0E-4 || (double)fArray[0] > 1.0E-4) {
            throw new IllegalArgumentException(J3dI18N.getString("PathInterpolator0"));
        }
        if ((double)(fArray[fArray.length - 1] - 1.0f) < -1.0E-4 || (double)(fArray[fArray.length - 1] - 1.0f) > 1.0E-4) {
            throw new IllegalArgumentException(J3dI18N.getString("PathInterpolator1"));
        }
        this.knots = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (i2 > 0 && fArray[i2] < fArray[i2 - 1]) {
                throw new IllegalArgumentException(J3dI18N.getString("PathInterpolator2"));
            }
            this.knots[i2] = fArray[i2];
        }
    }

    public void getKnots(float[] fArray) {
        for (int i2 = 0; i2 < this.knots.length; ++i2) {
            fArray[i2] = this.knots[i2];
        }
    }

    protected void computePathInterpolation(float f2) {
        for (int i2 = 0; i2 < this.knots.length; ++i2) {
            if (!(i2 == 0 && f2 <= this.knots[i2]) && (i2 <= 0 || !(f2 >= this.knots[i2 - 1]) || !(f2 <= this.knots[i2]))) continue;
            if (i2 == 0) {
                this.currentInterpolationValue = 0.0f;
                this.currentKnotIndex = 0;
                break;
            }
            this.currentInterpolationValue = (f2 - this.knots[i2 - 1]) / (this.knots[i2] - this.knots[i2 - 1]);
            this.currentKnotIndex = i2 - 1;
            break;
        }
    }

    protected void computePathInterpolation() {
        float f2 = this.alpha.value();
        this.computePathInterpolation(f2);
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        PathInterpolator pathInterpolator = (PathInterpolator)node;
        int n2 = pathInterpolator.getArrayLengths();
        this.knots = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setKnot(i2, pathInterpolator.getKnot(i2));
        }
    }
}

